string GetDescription()
{
	return "This is a simple, fixed classical inner structure:\n - Two musical sentences\n - each with two musical phrases\n - each with two bars";
}

void GenerateInnerStructure(UniquePart @up)
{
	// Set sentences
	up.SetSentences(2);
		
	up.GetSentence(0).SetPhrases(2);
	up.GetSentence(1).SetPhrases(2);

	// Set unique phrases
	up.SetUniquePhrases(RndInt(1,4));

	for (int i = 0; i < up.GetUniquePhrases(); i++)
		up.GetUniquePhrase(i).SetBars(2);
						
	if (up.GetUniquePhrases() == 1) // AAAA
	{
		up.GetSentence(0).GetPhrase(0).SetUniquePhrase(0);
		up.GetSentence(0).GetPhrase(1).SetUniquePhrase(0);
		up.GetSentence(1).GetPhrase(0).SetUniquePhrase(0);
		up.GetSentence(1).GetPhrase(1).SetUniquePhrase(0);
	}
	else if (up.GetUniquePhrases() == 2) // ABAB
	{
		up.GetSentence(0).GetPhrase(0).SetUniquePhrase(0);
		up.GetSentence(0).GetPhrase(1).SetUniquePhrase(1);
		up.GetSentence(1).GetPhrase(0).SetUniquePhrase(0);
		up.GetSentence(1).GetPhrase(1).SetUniquePhrase(1);
	}
	else if (up.GetUniquePhrases() == 3) // ABAC && ABCB
	{
		if (RndInt(0,1) == 0)
		{
			up.GetSentence(0).GetPhrase(0).SetUniquePhrase(0);
			up.GetSentence(0).GetPhrase(1).SetUniquePhrase(1);
			up.GetSentence(1).GetPhrase(0).SetUniquePhrase(0);
			up.GetSentence(1).GetPhrase(1).SetUniquePhrase(2);
		}
		else
		{
			up.GetSentence(0).GetPhrase(0).SetUniquePhrase(0);
			up.GetSentence(0).GetPhrase(1).SetUniquePhrase(1);
			up.GetSentence(1).GetPhrase(0).SetUniquePhrase(2);
			up.GetSentence(1).GetPhrase(1).SetUniquePhrase(1);
		}
	}
	else if (up.GetUniquePhrases() == 4) // ABCD
	{
		up.GetSentence(0).GetPhrase(0).SetUniquePhrase(0);
		up.GetSentence(0).GetPhrase(1).SetUniquePhrase(1);
		up.GetSentence(1).GetPhrase(0).SetUniquePhrase(2);
		up.GetSentence(1).GetPhrase(1).SetUniquePhrase(3);
	}		
}
